<?php
// مسیر config.php اصلاح شد (یک پوشه به عقب)
include __DIR__ . "/../config.php"; 
header('Content-Type: application/json');

// --- امنیت: فقط ادمین ها مجاز به دسترسی هستند ---
$admin_id = $_GET['admin_id'] ?? 0;
if (!in_array($admin_id, $admins)) {
  echo json_encode(['status' => 'error', 'message' => 'Access Denied.']);
  exit;
}
// -----------------------------------------

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data)) {
  echo json_encode(['status' => 'error', 'message' => 'No data received.']);
  exit;
}

// مسیر فایل theme.css (در همین پوشه)
$theme_file_path = __DIR__ . '/theme.css';

$css_content = file_get_contents($theme_file_path);
$current_vars = [];
preg_match_all('/(--[a-zA-Z0-9_-]+)\s*:\s*([^;]+);/m', $css_content, $matches, PREG_SET_ORDER);
foreach ($matches as $match) {
  $current_vars[trim($match[1])] = trim($match[2]);
}

$all_vars = array_merge($current_vars, $data);

$new_css_content = ":root {\n";
foreach ($all_vars as $var_name => $value) {
  $safe_var_name = preg_replace('/[^a-zA-Z0-9_-]/', '', $var_name);
  if ($safe_var_name !== $var_name) continue; 

  // این بخش پاکسازی برای مقادیری مثل linear-gradient مهم است
  $safe_value = trim($value); 
 
  $new_css_content .= "  $safe_var_name: $safe_value;\n";
}
$new_css_content .= "}\n";

// ذخیره در فایل (در همین پوشه)
if (file_put_contents($theme_file_path, $new_css_content) !== false) {
  echo json_encode(['status' => 'ok', 'message' => 'Theme saved successfully.']);
} else {
  echo json_encode(['status' => 'error', 'message' => 'Failed to write to theme.css file.']);
}
?>